<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\User;
use App\Models\Course;
use App\Models\Lesson;
use App\Models\Topic;
use App\Models\UserProgress;
use App\Models\UserLessonProgress;
use App\Models\QuizQuestion;

class AdminDashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_users' => User::count(),
            'total_courses' => Course::count(),
            'total_lessons' => Lesson::count(),
            'total_topics' => Topic::count(),
            'total_quiz_questions' => QuizQuestion::count(),
            'active_users' => UserProgress::distinct('user_id')->count(),
        ];

        return Inertia::render('Dashboard/Admin', [
            'stats' => $stats,
        ]);
    }
}