<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class ClearExpiredAccessCodes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:clear-expired-access-codes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting ClearExpiredAccessCodes...');

        try {
            // Delete access codes whose expiration date is older than 7 days
            $cutoff = now()->subDays(7);

            $deleted = \App\Models\AccessCode::whereNotNull('expires_at')
                ->where('expires_at', '<', $cutoff)
                ->delete();

            $this->info("Deleted {$deleted} expired access code(s) older than {$cutoff}.");
            return 0;
        } catch (\Exception $e) {
            $this->error('Failed to clear expired access codes: ' . $e->getMessage());
            return 1;
        }
    }
}
